<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

// Funci  n para obtener la IP p  blica del cliente
function getClientIP() {
    if (isset($_SERVER['HTTP_CLIENT_IP']) && filter_var($_SERVER['HTTP_CLIENT_IP'], FILTER_VALIDATE_IP)) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        // Manejar el caso en que el cliente est   detr  s de un proxy
        $ipList = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        foreach ($ipList as $ip) {
            $ip = trim($ip);
            if (filter_var($ip, FILTER_VALIDATE_IP)) {
                return $ip;
            }
        }
    } elseif (isset($_SERVER['REMOTE_ADDR']) && filter_var($_SERVER['REMOTE_ADDR'], FILTER_VALIDATE_IP)) {
        return $_SERVER['REMOTE_ADDR'];
    }
    return false; // IP no encontrada
}

// Funci  n para obtener la IP privada del servidor
function getPrivateIP() {
    return $_SERVER['SERVER_ADDR'] ?? '127.0.0.1'; // Fallback a localhost si no est   disponible
}

// Verificar si la solicitud GET contiene el flag 'obtenerIP'
if (isset($_GET['obtenerIP']) && $_GET['obtenerIP'] == 1) {
    $clientIP = getClientIP();
    $privateIP = getPrivateIP();

    if ($clientIP) {
        $response = array(
            "success" => true,
            "msg" => "IP encontrada",
            "ip" => $clientIP,
            "ip_privada" => $privateIP
        );
    } else {
        $response = array(
            "success" => false,
            "msg" => "La IP no fue encontrada",
            "ip_privada" => $privateIP
        );
    }
} else {
    $response = array(
        "success" => false,
        "msg" => "Flag 'obtenerIP' no proporcionado o inv  lido"
    );
}

// Devolver la respuesta en formato JSON
echo json_encode($response);
?>